#include <iostream>
#include "cloud.h"
#include "comm.h"

#include "clouds.h"

Clouds::Clouds() {
	first = new Cloud();
	last = new Cloud();
	first->set_next(last);
	no_elements = 0;
	iteration = last_iteration = 0;
}
Clouds::~Clouds() {
	Cloud* tmp = first, * tmp2;
	while(tmp) {
		tmp2 = tmp->get_next();
		delete tmp;
		tmp = tmp2;
	}
}

void Clouds::set_iteration(int nr) {
	last_iteration = iteration;
	iteration = nr;
}
int Clouds::get_iteration() {
	return iteration;
}
int Clouds::get_last_iteration() {
	return last_iteration;
}
void Clouds::add(Cloud* cl) {
	Cloud* p = first, * q = first->get_next();
	while(q != last && q->get_vapour() < cl->get_vapour()) {
		p = q;
		q = q->get_next();
	}

	cl->set_next(q);
	p->set_next(cl);
	no_elements++;
}
void Clouds::addp(Cloud* cl) {
	Cloud* p = first, * q = first->get_next();
	while(q != last && q->get_points() > cl->get_points()) {
		p = q;
		q = q->get_next();
	}

	cl->set_next(q);
	p->set_next(cl);
	no_elements++;
}
void Clouds::calculate(Cloud* me) {
	Cloud* tmp = first->get_next(), * tmp2;
	Cloud* f, * l;
	while(tmp != last) {
		tmp->cal_points(me);
		tmp = tmp->get_next();
	}
	
	f = first;
	l = last;
	first = new Cloud();
	last = new Cloud();
	first->set_next(last);
	no_elements = 0;

	tmp = f->get_next();
	while(tmp != l) {
		tmp2 = tmp;
		tmp = tmp2->get_next();
		this->addp(tmp2);
	}
	delete f;
	delete l;
}
void Clouds::next_move(Comm* c, Cloud* me) {
	Cloud* tmp;
	tmp = this->remove_no(1);
	if(tmp->get_points() > 40)
		tmp->next_move(c, me);
	this->addp(tmp);
}
Cloud* Clouds::remove_no(int nr) {
	Cloud* p = first, * q = first->get_next();
	for(int i = 1; i < nr; i++) {
		p = q;
		q = q->get_next();
	}
	p->set_next(q->get_next());
	return q;
}
void Clouds::flush() {
	Cloud* tmp = first->get_next(), * tmp2;
	while(tmp != last) {
		tmp2 = tmp->get_next();
		delete tmp;
		tmp = tmp2;
	}
	no_elements = 0;
	first->set_next(last);
}

//DEBUG FUNCTIONS
void Clouds::display() {
	Cloud* tmp = first->get_next();
	while(tmp != last) {
		tmp->display();
		tmp = tmp->get_next();
	}
}